/* PUGSMOOTH.C  Laplachian smoothing for grid */

#include "pug.h"

void smoothonce(/* node *nh; */);

/* Smooths the list of nodes maxiter times */
void smooth(nh,maxiter)
	 node *nh;
	 int maxiter;
{
  int i;

  for(i=0;i<maxiter;i++) smoothonce(nh);
}


/* Performs a single iteration of Laplachian smoothing */
void smoothonce(nh)
	 node *nh;
{
  int numneighbours,tcorn;
  double x,y;
  triangle *t;
  node *n;
  
  n=nh;
  while(n!=NULL) {

	if(!((n->flags)&FLAG_RealBoundary)) {

	  x=0.0; y=0.0;
	  numneighbours=0;
	  
	  t=n->thead;
	  while(t!=NULL) {

		tcorn=WhichCorner(t,n);
		
		numneighbours+=2;
		x += (t->c[(tcorn+1)%3].n)->x;
		y += (t->c[(tcorn+1)%3].n)->y;
		
		x += (t->c[(tcorn+2)%3].n)->x;
		y += (t->c[(tcorn+2)%3].n)->y;

		t=t->c[tcorn].next;
	  }

	  if(numneighbours>0) {

		n->x = x/((double)numneighbours);
		n->y = y/((double)numneighbours);
	  }
	}

	n=n->next;
  }
}
