/* PUGSOLVE.C   Set of equations solver */

#include "pug.h"



/* This routine solves for phis[nfs] using an iterated point-by-point 
   Gauss-Seidel algorithm */

void solve(nh,nfs)
	 node *nh;
	 int nfs;
{
  int sweep,tcorn;
  double s;
  node *n;
  triangle *t;

  /* Naively, this simply scans through the list of nodes giving
	 new values for phi[nfs] for each node based on the 
	 neighbouring nodes having an assumed phi. No attempt is
	 currently made to optimize this operation in terms of
	 its tour through the nodes */

  for(sweep=0;sweep<phis[nfs].nswp;sweep++) {

	n=nh;
	while(n!=NULL) {
	  
	  s = n->acon;
	  t = n->thead;
	  
	  while(t!=NULL) {
		
		tcorn = WhichCorner(t,n);
		
		s += (t->c[tcorn].a[0]) * ((t->c[(tcorn+1)%3].n)->phi[nfs]);
		s += (t->c[tcorn].a[1]) * ((t->c[(tcorn+2)%3].n)->phi[nfs]);
		
		t = t->c[tcorn].next;
	  }
	  
	  if(n->ac!=0.0) n->phi[nfs] = s/n->ac;
	  
	  n = n->next;
	}
  }
}
