/* PUGTRI0.C  Triangulating the base quads of the quadtree */


#include "pug.h"

int numclass0;


/* Triangulate the base quad, given the nodes forming the four corners
   (nul,nur,nbr,nbl) and with the possibility of a node on any or each of the
   four sides */
void triangulate_quad(th,q,nt,nr,nb,nl)
	 triangle **th;
	 quadtree *q;
	 node *nt,*nr,*nb,*nl;
{

  /* No edges in quad */
  if(q->elhead==NULL) {
	numclass0++;
	triangulate_quad0(th,q,nt,nr,nb,nl);
  } else if(q->elhead->next==NULL) {
	triangulate_quad1(th,q,nt,nr,nb,nl);
  } else {
	triangulate_quad2(th,q,nt,nr,nb,nl);
  }
}


/* Triangulate the base quad, assuming that no edges intersect the
   given quad. Also given the nodes forming the four corners
   (nul,nur,nbr,nbl) and with the possibility of a node on any or each of the
   four sides */
void triangulate_quad0(th,q,nt,nr,nb,nl)
	 triangle **th;
	 quadtree *q;
	 node *nt,*nr,*nb,*nl;
{
  int i;

  i = 0;
  if(nt!=NULL) i |= 8;
  if(nr!=NULL) i |= 4;
  if(nb!=NULL) i |= 2;
  if(nl!=NULL) i |= 1;

  switch(i) {

	/* No midpoints */
  case 0:
	make_triangle(th,q->nul,q->nur,q->nbr);
	make_triangle(th,q->nul,q->nbr,q->nbl);
	break;

	/* 1 midpoint */
  case 1:
	make_triangle(th,q->nul,q->nur,nl);
	make_triangle(th,q->nur,q->nbr,nl);
	make_triangle(th,q->nbl,nl,q->nbr);
	break;
  case 2:
	make_triangle(th,q->nul,q->nur,nb);
	make_triangle(th,q->nur,q->nbr,nb);
	make_triangle(th,q->nbl,q->nul,nb);
	break;
  case 4:
	make_triangle(th,q->nul,q->nur,nr);
	make_triangle(th,q->nul,nr,q->nbl);
	make_triangle(th,q->nbl,nr,q->nbr);
	break;
  case 8:
	make_triangle(th,q->nul,nt,q->nbl);
	make_triangle(th,q->nbl,nt,q->nbr);
	make_triangle(th,q->nbr,nt,q->nur);
	break;

	/* 2 midpoints */
  case 3:
	make_triangle(th,q->nul,q->nur,nl);
	make_triangle(th,nl,q->nur,nb);
	make_triangle(th,nb,q->nur,q->nbr);
	make_triangle(th,q->nbl,nl,nb);
	break;
  case 5:
	make_triangle(th,q->nul,q->nur,nr);
	make_triangle(th,q->nul,nr,nl);
	make_triangle(th,nl,nr,q->nbr);
	make_triangle(th,q->nbl,nl,q->nbr);
	break;
  case 9:
	make_triangle(th,q->nul,nt,nl);
	make_triangle(th,nt,q->nur,q->nbr);
	make_triangle(th,nl,nt,q->nbr);
	make_triangle(th,q->nbl,nl,q->nbr);
	break;
  case 6:
	make_triangle(th,q->nul,q->nur,nr);
	make_triangle(th,q->nul,nr,nb);
	make_triangle(th,nb,nr,q->nbr);
	make_triangle(th,q->nbl,q->nul,nb);
	break;
  case 10:
	make_triangle(th,q->nul,nb,q->nbl);
	make_triangle(th,q->nul,nt,nb);
	make_triangle(th,nt,q->nbr,nb);
	make_triangle(th,q->nur,q->nbr,nt);
	break;
  case 12:
	make_triangle(th,q->nul,nt,q->nbl);
	make_triangle(th,nt,q->nur,nr);
	make_triangle(th,nt,nr,q->nbl);
	make_triangle(th,q->nbl,nr,q->nbr);
	break;

	/* 3 midpoints */
  case 7:
	make_triangle(th,q->nul,q->nur,nr);
	make_triangle(th,q->nul,nr,nl);
	make_triangle(th,nl,nr,nb);
	make_triangle(th,q->nbl,nl,nb);
	make_triangle(th,nb,nr,q->nbr);
	break;
  case 11:
	make_triangle(th,q->nul,nt,nl);
	make_triangle(th,nl,nt,nb);
	make_triangle(th,nl,nb,q->nbl);
	make_triangle(th,nb,nt,q->nbr);
	make_triangle(th,q->nbr,nt,q->nur);
	break;
  case 13:
	make_triangle(th,q->nul,nt,nl);
	make_triangle(th,nt,nr,nl);
	make_triangle(th,nt,q->nur,nr);
	make_triangle(th,nl,nr,q->nbr);
	make_triangle(th,q->nbl,nl,q->nbr);
	break;
  case 14:
	make_triangle(th,q->nul,nt,q->nbl);
	make_triangle(th,nt,nb,q->nbl);
	make_triangle(th,nt,q->nur,nr);
	make_triangle(th,nt,nr,nb);
	make_triangle(th,nb,nr,q->nbr);
	break;

	/* 4 midpoints */
  case 15:
	make_triangle(th,q->nul,nt,nl);
	make_triangle(th,nt,nr,nl);	
	make_triangle(th,nt,q->nur,nr);
	make_triangle(th,nl,nr,nb);
	make_triangle(th,q->nbl,nl,nb);
	make_triangle(th,nb,nr,q->nbr);
	break;

  default:
	fprintf(stderr,"Uh oh. Unanticipated case in triangulation...\n");
	make_triangle(th,q->nul,q->nur,q->nbr);
	make_triangle(th,q->nul,q->nbr,q->nbl);
	break;
  }
}
