/* PUGTRI1.C  Triangulating the base quads of the quadtree when
   there's 1 input edge intersecting the quad */


#include "pug.h"


extern int numclass0;
int numclass1;
int numclass1adj;
int numclass1opp;


static int classify1edge(/* edgelist *elhead; 
							node *nul,*nur,*nbr,*nbl,*nt,*nr,*nb,*nl; */);
static void triangulate_opposing(/* edgelist *e;
									node *nul,*nur,*nbr,*nbl,*nt,*nr,*nb,*nl; */);


/* Triangulate the base quad, given the nodes forming the four corners
   (nul,nur,nbr,nbl) and with the possibility of a node on any or each of the
   four sides */
void triangulate_quad1(th,q,nt,nr,nb,nl)
	 triangle **th;
	 quadtree *q;
	 node *nt,*nr,*nb,*nl;
{
  node n1,n2;
  numclass1++;

  classify1edge(q->elhead,q->nul,q->nur,q->nbr,q->nbl,nt,nr,nb,nl);

  triangulate_quad0(th,q,nt,nr,nb,nl);
}


/* Determine which subcategory of 1 edge intersecting this
   quad falls into */
static int classify1edge(elhead,nul,nur,nbr,nbl,nt,nr,nb,nl)
	 edgelist *elhead;
	 node *nul,*nur,*nbr,*nbl,*nt,*nr,*nb,*nl;
{
  double ix1,iy1,ix2,iy2;
  int r = 0;

  /* Ensure that the edge enters from the left in a non-degenerate position */
  do {
	if(intersectionpoint(nbl,nul,elhead->n1,elhead->n2,&ix1,&iy1) &&
	   (!DoubleEQ(ix1,nul->x) || !DoubleEQ(iy1,nul->y)))
	  break;	  

	/* If the edge did not intersect the left edge, we rotate until it does */
	rotatecounterclockwise(&nul,&nur,&nbr,&nbl,&nt,&nr,&nb,&nl);
	  
	r++;
  } while(r<4);
  
  if(r>=4) {
	/* This case should never occur */
	fprintf(stderr,"Danger! Unanticipated case in the triangulation. Quitting now...\n");

	exit(1);
  }
  
  /* At this point it must be that the edge intersects the left side of
	 the square, somewhere along it or at the bottom left corner */
  
  /* Now, to locate the other intersection */
  
  /* Adjacent: Left-Top intersection */
  if(intersectionpoint(nul,nur,elhead->n1,elhead->n2,&ix2,&iy2) &&
	 (ix2!=nur->x || iy2!=nur->y)) {
	
	reflectvertically(&nul,&nur,&nbr,&nbl,&nt,&nr,&nb,&nl);
	numclass1adj++;

	  /* Opposing edges */
  } else if(intersectionpoint(nur,nbr,elhead->n1,elhead->n2,&ix2,&iy2)) {

	/* Ensure that relative to the left-side (whichever edge that may
	   actually be after rotating) the slope of the line is positive */
	switch(r) {
	case 0: if(iy1>iy2) reflectvertically(&nul,&nur,&nbr,&nbl,&nt,&nr,&nb,&nl); 
	  break;
	case 1: if(ix1>ix2) reflectvertically(&nul,&nur,&nbr,&nbl,&nt,&nr,&nb,&nl);
	  break;
	case 2: if(iy1<iy2) reflectvertically(&nul,&nur,&nbr,&nbl,&nt,&nr,&nb,&nl);
	  break;
	case 3: if(ix1<ix2) reflectvertically(&nul,&nur,&nbr,&nbl,&nt,&nr,&nb,&nl);
	  break;
	}

	numclass1opp++;

	/* Adjacent: Left-Bottom */
  } else if(intersectionpoint(nbr,nbl,elhead->n1,elhead->n2,&ix2,&iy2) &&
			(ix2!=nbl->x || iy2!=nbl->y)) {  
	
	numclass1adj++;
  } else {

	/* If we get here, then it must be that the input edge is colinear
	   with one of the sides. Now, colinear edges can be safely ignored
	   in the triangulation phase, provided that any vertices created along
	   the edge split the edge appropriately ...? (maybe -- haven't fully thought
	   it out) */
	numclass1--;
	numclass0++;
  }

  return(0);
}


/* Triangulates the square when the input edge intersects
   opposing sides of the square. Assume that the input
   edge intersects the square on the left side, strictly
   below the top-left corner, and intersects the right
   edge with a positive slope */
static void triangulate_opposing(e,nul,nur,nbr,nbl,nt,nr,nb,nl)
	 edgelist *e;
	 node *nul,*nur,*nbr,*nbl,*nt,*nr,*nb,*nl;
{
  node n,*nmid;
  double ix1,iy1,ix2,iy2;

  /* A single opposing edge intersection is further subdivided into
	 one of two cases: Below-Below or Below-Above. The case 
	 Above-Above is a rotation by Pi of some Below-Below case, and
	 Above-Below will never occur if the slope is positive */

  if(nl==NULL) {
	nmid = &n;
	n.x = (nbl->x - nul->x)/2.0 + nbl->x;
	n.y = (nbl->y - nul->y)/2.0 + nbl->y;
  } else {
	nmid = nl;
  }

  /* Check for Above intersection on the left. If there is one, then
	 rotate it by Pi */
  if(intersectionpoint(nmid,nul,e->n1,e->n2,&ix1,&iy1)) {
	rotatecounterclockwise(&nul,&nur,&nbr,&nbl,&nt,&nr,&nb,&nl);
	rotatecounterclockwise(&nul,&nur,&nbr,&nbl,&nt,&nr,&nb,&nl);
  }

  /* See whether it intersects above or below on the right side */

  if(nr==NULL) {
	nmid = &n;
	n.x = (nbr->x - nur->x)/2.0 + nbr->x;
	n.y = (nbr->y - nur->y)/2.0 + nbr->y;
  } else {
	nmid = nr;
  }

  /* Intersection Below-Above 
  if(intersectionpoint(nmid,nur,e->n1,e->n2,&ix2,&iy2)) 
	triangulate_opposing_BA(e,nul,nur,nbr,nbl,nt,nr,nb,nl);
  else if(intersectionpoint(nbr,nmid,e->n1,e->n2,&ix2,&iy2)) 
	triangulate_opposing_BB(e,nul,nur,nbr,nbl,nt,nr,nb,nl);
  else {
	fprintf(stderr,"Uh oh. Unanticipated Case in triangulation..\n");
	exit(1);
  }  
  */
}

