/* PUGTRI1_O.C  Triangulating the base quads of the quadtree when
   there's 1 input edge intersecting the quad through opposing sides */


#include "pug.h"


extern int numclass0;
extern int numclass1;
extern int numclass1adj;
extern int numclass1opp;


/* Note that these routines assume a counter-clockwise orientation of
   the nodes in the edge list */


/* Triangulate a quad containing an opposing edge of subclass BA */
void triangulate_opposing_BA(e,nul,nur,nbr,nbl,nt,nr,nb,nl)
	 edgelist *e;
	 node *nul,*nur,*nbr,*nbl,*nt,*nr,*nb,*nl;
{
  int i;
  double ix1,iy1,ix2,iy2;
  node *en1,*en2;

  /* Decide which side to triangulate, based on which side is internal
	 to the domain */

  i=sarea(e->n1,e->n2,nul);
  if(i==Sarea_Right) {
	/* This routine assumes we're triangulating the upper left, so
	   this case needs to be rotated by Pi */
	rotatecounterclockwise(&nul,&nur,&nbr,&nbl,&nt,&nr,&nb,&nl);
	rotatecounterclockwise(&nul,&nur,&nbr,&nbl,&nt,&nr,&nb,&nl);
  }

  /* Now we know we're triangulating the upper-left corner area */
  intersectionpoint(nbl,nul,e->n1,e->n2,&ix1,&iy1);
  intersectionpoint(nbr,nur,e->n1,e->n2,&ix2,&iy2);

  /* Build nodes for the intersection. Note that this is
	 a temporary solution -- the nodes created this way in each
	 quad have to be kept consistent somehow */

  en1 = newnode(ix1,iy1,FLAG_Temp);

  /* The actual triangulation */

  /* BA-0: no midpoints */
  if(nl==NULL && nt==NULL) {

  }
}


