/* PUGUSR.C  User alterable subroutines */

#include "pug.h"


/* Fill in initial values of cv coefficients and parameters needed
   for various phi's */
void start(nh,phis)
	 node *nh;
	 phidescr *phis;
{
  int i;
  node *n;

  /* Setup for first phi -- TEXACT */
  phis[TEXACT].lsolve = False;
  phis[TEXACT].lprint = True;
  phis[TEXACT].relax = 1.0;
  phis[TEXACT].title = "TExact";

  /* Setup for second phi -- TCOMP */
  phis[TCOMP].lsolve = True;
  phis[TCOMP].lprint = True;
  phis[TCOMP].relax = 1.0;
  phis[TCOMP].title = "TComp";
  phis[TCOMP].nswp = solve_sweeps;

  /* Setup any remaining phis */
  for(i=TCOMP+1;i<NV;i++) {
	phis[i].lsolve = False;
	phis[i].lprint = False;
  }

  n=nh;

  /* And run through nodal points setting initial phi`s */

  while(n!=NULL) {

	n->phi[TEXACT] = 5.0 * (n->x * n->x) - 6.0 * (n->y * n->y); 
	/* n->phi[TEXACT] = 6.0 * n->y + 15.0; */
	n->phi[TCOMP] = 0.0;

	n=n->next;
  }
}


/* Assign gamma and source terms to each node for the given phi 
   being solved */
void gamsor(nh,nfs)
	 node *nh;
	 int nfs;
{
  node *n;
  
  n=nh;
  while(n!=NULL) {

	n->gamma = 1.0;
	n->sc = 2.0; 
	/* n->sc = 0.0; */
	n->sp = 0.0;

	n=n->next;
  }
}


/* Specify boundary conditions for each phi if required.
   Phi is specified at the boundaries */
void bound(nh,nfs)
	 node *nh;
	 int nfs;
{
  int tcorn;
  node *n;
  triangle *t;


  /* We simply go through the entire list of nodes. Each time we
     find a boundary node, we set the coefficients appropriately */

  n=nh;
  while(n!=NULL) {
	
	if((n->flags)&FLAG_RealBoundary) {
	  
	  t = n->thead;      
	  while(t!=NULL) {              /* For each triangle ... */

		tcorn=WhichCorner(t,n);
		t->c[tcorn].a[0] = 0.0;
		t->c[tcorn].a[1] = 0.0;

		t=t->c[tcorn].next;
	  }

	  n->ac = 1.0;
	  n->acon = n->phi[TEXACT];
	}

	n=n->next;
  }
}



/* Monitor. Returns boolean True if the grid has reached convergence
   for all phis, and False otherwise. Currently, this isn't
   implemented */
int monit(nh,th)
	 node *nh;
	 triangle *th;
{
  return(False);
}
