/* SAREA.C   Module with functions to compute signed area of
   a triangle */


#include "pug.h"


int sarea(n0,n1,n2)
   node *n0,*n1,*n2;
{
  /* Returns a value:
	 Sarea_Left   n0,n1,n2 makes a left turn
	 Sarea_Right  n0,n1,n2 makes a right turn
	 Sarea_None   n0,n1,n2 are colinear
	 Note that Right < None < Left
	 */
  double cross;
  
  cross = (n1->x-n0->x)*(n2->y-n0->y) - (n2->x-n0->x)*(n1->y-n0->y);
  
  return((cross>0.0) ? Sarea_Left : ((cross==0.0) ? Sarea_None : Sarea_Right));
}


int insidesquare(p,c1,c2,c3,c4) 
   node *p,*c1,*c2,*c3,*c4;
{
  if(sarea(c1,p,c2)==Sarea_Left && sarea(c2,p,c3)==Sarea_Left &&
     sarea(c3,p,c4)==Sarea_Left && sarea(c4,p,c1)==Sarea_Left)
    return(True);
  return(False);
}


/* Calculates the intersection point of the 
   two line segments. If they do no intersect,
   returns False. Otherwise, returns True, and
   if xi and yi are not NULL fills in the intersection
   point */
int intersectionpoint(s0,e0,s1,e1,xi,yi)
	 node *s0,*e0,*s1,*e1;
	 double *xi,*yi;
{
  double dx0,dx1,dy0,dy1,inx,iny;

  /* Ensure the starting point of each line is left of the
	 ending point */
  if(s0->x > e0->x) return(intersectionpoint(e0,s0,s1,e1,xi,yi));
  if(s1->x > e1->x) return(intersectionpoint(s0,e0,e1,s1,xi,yi));

  /* Calculate delta-x and delta-y for each line */
  dx0 = (e0->x-s0->x); dy0 = (e0->y-s0->y);
  dx1 = (e1->x-s1->x); dy1 = (e1->y-s1->y);

  /* Parallel lines can overlap, but this is not important
	 to the rest of the algorithm, thus we can assume
	 each pair of lines intersects somewhere */
  if((dx0==0.0 && dx1==0.0) ||
	 (dx0!=0.0 && dx1!=0.0 && dy0/dx0==dy1/dx1))
	return(False);

  /* Vertical lines are a pain, so they're dealt with separately */
  if(dx0!=0.0 && dx1!=0.0) {
	double b0,b1,a0,a1;

	/* Determine equation of each lines as y = ax + b */
	a0 = dy0/dx0; a1 = dy1/dx1;
	b0 = e0->y - a0*e0->x;
	b1 = e1->y - a1*e1->x;

	/* And calculate intersection point */
	inx = (b1 - b0)/(a0-a1);
	iny = inx*a0 + b0;

	/* And see if it lies on each of the line segments */
	if(inx<s0->x || inx>e0->x || inx<s1->x || inx>e1->x)
	  return(False);

	if(xi!=NULL) *xi = inx;
	if(yi!=NULL) *yi = iny;

	/*fprintf(stderr,"Intersection: [(%g,%g),(%g,%g)] with",
			s0->x,s0->y,e0->x,e0->y);
	fprintf(stderr," [(%g,%g),(%g,%g)]\n",
			s1->x,s1->y,e1->x,e1->y);*/

	return(True);
  } 

  /* Here, one of the lines must be vertical */
  if(dx1==0.0) return(intersectionpoint(s1,e1,s0,e0,xi,yi));
  if(s0->y > e0->y) return(intersectionpoint(e0,s0,s1,e1,xi,yi));

  /* Here, line 0 must be vertical. All we need to check
	 to determine if there's an intersection is to see
	 if y1 = a1*x0 + b1 is contained in the second segment */
  iny = (dy1/dx1)*(s0->x) + e1->y - (dy1/dx1)*e1->x;

  if(iny<s0->y || iny>e0->y || s0->x<s1->x || s0->x>e1->x)
	return(False);

  if(xi!=NULL) *xi = s0->x;
  if(yi!=NULL) *yi = iny;

  /*fprintf(stderr,"Intersection: [(%g,%g),(%g,%g)] with",
		  s0->x,s0->y,e0->x,e0->y);
  fprintf(stderr," [(%g,%g),(%g,%g)]\n",
		  s1->x,s1->y,e1->x,e1->y);*/

  return(True);
}

