/* =================== PROGRAM bitonic===================== */

#include <stdio.h>    /* Standard I/O */
#include <malloc.h>   

/* =============== NODE STRUCTURE =================== */

struct node {
  int value;
  struct node *left;
  struct node *right;
  };

typedef struct node HANDLE;

#define NIL ((HANDLE *) 0)


HANDLE *
/********/
NewNode(v)
/********/
int v;

{ HANDLE *h;
  
  h = malloc();
  h->value = v;
  h->left = NIL;
  h->right = NIL;
  return(h);
} 

void
/*****************/
PrintIndent(n,path)
/*****************/
int n;
int path;

{ int divisor;
  
  if ((n == 0))
    puts("*");
  divisor = (1 << (n - 1));
  while ((n > 0))
    { if ((n == 1))
        if ((path == 0))
          puts("/----->");
        else 
          puts("\\----->");
      else 
        if (((path / divisor) == ((path % divisor) / (divisor / 2))))
          puts("       ");
        else 
          puts("|      ");
      path = (path % divisor);
      divisor = (divisor / 2);
      n = (n - 1);
    }
} 

void
/********************/
PrintSubTree(h,n,path)
/********************/
HANDLE *h;
int n;
int path;

{ HANDLE *l;
  HANDLE *r;
  
  if ((h != NIL))
    { r = h->right;
      PrintSubTree(r,(n + 1),(path * 2));
      puts("(");
      put(n);
      puts(")\t");
      PrintIndent(n,path);
      puts(" ");
      put(h->value);
      puts("\n");
      l = h->left;
      PrintSubTree(l,(n + 1),((path * 2) + 1));
    }
} 

void
/**********/
PrintTree(h)
/**********/
HANDLE *h;

{ 
  PrintSubTree(h,0,0);
} 

void
/********/
InOrder(h)
/********/
HANDLE *h;

{ HANDLE *l;
  HANDLE *r;
  
  if ((h != NIL))
    { l = h->left;
      r = h->right;
      InOrder(l);
      put(h->value);
      puts(" ");
      InOrder(r);
    }
} 

HANDLE *
/*********/
RandTree(n)
/*********/
int n;

{ int next_val;
  HANDLE *h;
  HANDLE *l;
  HANDLE *r;
  
  if ((n > 1))
    { next_val = random();
      h = NewNode(next_val);
      l = RandTree((n / 2));
      r = RandTree((n / 2));
      h->left = l;
      h->right = r;
      /* EmptyStatement */
    }
  else 
    h = NIL;
  return(h);
} 

void
/************/
SwapValue(l,r)
/************/
HANDLE *l;
HANDLE *r;

{ int temp;
  
  temp = l->value;
  l->value = r->value;
  r->value = temp;
} 

void
/***********/
SwapLeft(l,r)
/***********/
HANDLE *l;
HANDLE *r;

{ HANDLE *ll;
  HANDLE *rl;
  
  ll = l->left;
  rl = r->left;
  l->left = rl;
  r->left = ll;
} 

void
/************/
SwapRight(l,r)
/************/
HANDLE *l;
HANDLE *r;

{ HANDLE *lr;
  HANDLE *rr;
  
  lr = l->right;
  rr = r->right;
  l->right = rr;
  r->right = lr;
} 

void
/********************/
Bimerge(root,sp_r,dir)
/********************/
HANDLE *root;
HANDLE *sp_r;
int dir;

{ int rightexchange;
  int elementexchange;
  int temp;
  HANDLE *sp_l;
  HANDLE *pl;
  HANDLE *pr;
  HANDLE *rl;
  HANDLE *rr;
  
  rightexchange = ((root->value > sp_r->value) ^ dir);
  if (rightexchange)
    SwapValue(root,sp_r);
  pl = root->left;
  pr = root->right;
  while ((pl != NIL))
    { elementexchange = ((pl->value > pr->value) ^ dir);
      if (rightexchange)
        if (elementexchange)
          { SwapValue(pl,pr);
            SwapRight(pl,pr);
            pl = pl->left;
            pr = pr->left;
          }
        else 
          { pl = pl->right;
            pr = pr->right;
          }
      else 
        if (elementexchange)
          { SwapValue(pl,pr);
            SwapLeft(pl,pr);
            pl = pl->right;
            pr = pr->right;
          }
        else 
          { pl = pl->left;
            pr = pr->left;
          }
    }
  if ((root->left != NIL))
    { rl = root->left;
      rr = root->right;
      sp_l = NewNode(root->value);
      Bimerge(rl,sp_l,dir);
      Bimerge(rr,sp_r,dir);
      root->value = sp_l->value;
    }
} 

void
/*******************/
Bisort(root,sp_r,dir)
/*******************/
HANDLE *root;
HANDLE *sp_r;
int dir;

{ HANDLE *l;
  HANDLE *r;
  HANDLE *sp_l;
  
  if ((root->left == NIL))
    { if (((root->value > sp_r->value) ^ dir))
        SwapValue(root,sp_r);
    }
  else 
    { l = root->left;
      r = root->right;
      sp_l = NewNode(root->value);
      Bisort(l,sp_l,dir);
      Bisort(r,sp_r,(! dir));
      root->value = sp_l->value;
      Bimerge(root,sp_r,dir);
    }
} 

void
/*********/
main(n)
/*********/
int n;

{ HANDLE *h;
  HANDLE *s;
  int sval;
  int height;
  
  h = RandTree(n);
  sval = random();
  s = NewNode(sval);
  puts("Original Tree: ");
  PrintTree(h);
  InOrder(h);
  put(s->value);
  puts("\n");
  Bisort(h,s,0);
  puts("Sorted Tree: ");
  PrintTree(h);
  InOrder(h);
  put(s->value);
  puts("\n");
  Bisort(h,s,1);
  puts("Sorted Tree: ");
  PrintTree(h);
  InOrder(h);
  put(s->value);
  puts("\n");
} 

