/* the was converted to pgm4.c */
/* hash.c */





/* The following will be an implementation of a hash table.  It will basically
 * just take, as input, a large number of text strings (no spaces) and will
 * enter them into the hash table.  This provides some good exercise with
 * basic integer arithmatic, array referencing, and pointer (linked list)
 * manipulation....
 */


#include <stdio.h>
#include <malloc.h>



/* defines and other constants go here.
 */
#define PRIME		211
#define HASH_SIZE	PRIME	/* Left somewhat small to force list stuff */
#define MAX_LINE	100	/* Max length of one input word */
#define TRUE		1
#define FALSE		0




/* Function prototypes follow
 */
int hashfunction (char *HashMeBaby);
void RemoveNl (char *GetItOffMe);
void AddToTable (char *INeedAHome);
int CheckTable (char *AmIHere);



/* Data structures that will be used for the hash table
 */
typedef struct NodeTag {
	char *string;
	struct NodeTag *next;
} StringNode;





/* Global variables that we will use for the hash table program:
 */

StringNode *HashTable[HASH_SIZE];



/* Main functin dude.  Reads in input, puts all the words in the hash table,
 * and then reads in some more values, just to check out how well it put
 * them in....
 */
void main (void)
{
	char inbuf[MAX_LINE];		/* Input buffer */
	int i;				/* Loop index */
	int result;			/* Result of lookup */

	/* The following loop just initializes the hash table to NULL
	 */
	for (i=0; i < HASH_SIZE; i++)
		{
		HashTable[i] = NULL;
		}


	/* Main driver loop that adds everything in and puts all the words
	 * into the loop
	 */
	fgets(inbuf, MAX_LINE, stdin);
	RemoveNl(inbuf);

	while (strcmp(inbuf, "END OF INPUT"))
		{
		AddToTable(inbuf);
		fgets(inbuf, MAX_LINE, stdin);
		RemoveNl(inbuf);
		}



	/* The following loop just reads in some more words and checks
	 * to see whether or not they are in the table....
	 */
	fgets(inbuf, MAX_LINE, stdin);
	RemoveNl(inbuf);

	while (strcmp(inbuf, "END OF RUN"))
		{
		result = CheckTable(inbuf);

		if (!result)
			{
			printf("\n'%s' isn't in the hash table", inbuf);
			}
		fgets(inbuf, MAX_LINE, stdin);
		RemoveNl(inbuf);
		}

	puts(" ");

}

/* The following function just takes the input string, and tries to see
 * if it is in the table or not.
 */
int CheckTable (char *AmIHere)
{
	int MyHashNumber;			/* Hash value of string */
	StringNode *tempptr;

	MyHashNumber = hashfunction(AmIHere);

	if (HashTable[MyHashNumber] == NULL)
		{
		/* Entire list for hash number is empty */
		return FALSE;
		}
	   else
		{
		/* List for this number isn't empty
		 */
		tempptr = HashTable[MyHashNumber];
		while (tempptr)
			{
			if (!strcmp(tempptr->string, AmIHere))
				{
				/* Found our string!
				 */
				return TRUE;
				}

			tempptr = tempptr->next;
			}
		}

	/* Never did find it in the list....
	 */
	return FALSE;
}
		

/* The following function just adds the given string to the hash table. It
 * first has to call the hash function, and then stick in the appropriate
 * linked list...
 */
void AddToTable (char *INeedAHome)
{
	int MyHashNumber;			/* Hash value of string */
	StringNode *AddMePlease;		/* New node to add */
	StringNode *tempptr, *oldptr;		/* Temp pointers */
	char *newstring;

	newstring = (char *) malloc(MAX_LINE);
	strncpy(newstring, INeedAHome, MAX_LINE-1);


	AddMePlease = (StringNode *) malloc (sizeof(struct NodeTag));
	AddMePlease->string = newstring;
	AddMePlease->next = NULL;

	MyHashNumber = hashfunction(INeedAHome);
	
	if (HashTable[MyHashNumber] == NULL)
		{
		HashTable[MyHashNumber] = AddMePlease;
		}
	    else
		{
		tempptr = HashTable[MyHashNumber];

		/* First check to see if the string is already in the
		 * list -- if so return, else, go through, and add it to
		 * the end.
		 */
		while (tempptr)
			{
			if (!strcmp(tempptr->string, newstring))
				{
				return;
				}

			oldptr = tempptr;
			tempptr = tempptr->next;
			}

		oldptr->next = AddMePlease;

		}

#ifdef DEBUG
printf("\nAdded '%s' to Table", INeedAHome);
#endif

}







		
/* The following is a hashing function stolen shamelessly from page 436 of
 * Aho, Sethi, and Ullmans Dragon Book.
 * Boos and groans to the person who came up with the variable names
 */
int hashfunction (char *HashMeBaby)
{
	char *p;
	unsigned int h = 0, g;

	for (p = HashMeBaby; *p != '\0'; p++)
		{
		h = (h << 4) + (*p);
		if (g = h & 0xf0000000)
			{
			h ^= (g >> 24);
			h ^= g;
			}
		}

	return h % PRIME;
}



/* The following function just searches through a string looking for a new
 * line character, and just replaces it with a '\0' if one is found.
 */
void RemoveNl (char *GetItOffMe)
{
	char *tmp;

	tmp = GetItOffMe;

	while (*tmp)
		{
		if (*tmp == '\n')
			{
			*tmp = '\0';
			return;
			}

		tmp++;
		}
}
