#include<stdio.h>
#include <math.h>
#define ARRAYSIZE 1000

/* This Program computes cubic spline functions. Given a group of points of   */
/* certain curve, which is unknown to people, we try to approximate the curve */
/* by spline functions. */ 

int main()
{
  float x_arr[ARRAYSIZE], y_arr[ARRAYSIZE]; 
  float x,y;
  int arr_size,i,j;
  
  i=0;

/* Store all the points from input file into array */
/* Each line have two values, x_coordinates and y_coordinates */

  while (scanf("%f %f\n",&x, &y) != EOF)
    {	
      x_arr[i]=x;
      y_arr[i]=y;
      i++;
    }
  
 /* printf ("The number of data points is %d\n",i); */
  arr_size=i;	

/* Call function spline to approximate the unknown curve */
  spline(arr_size,x_arr,y_arr);

  error_check(arr_size);
  
  return 0;
}
/*end of main*/

/*===============================================*/

void spline (int arr_size, float *x_arr, float *y_arr)
{
  float *h_arr, *di_arr, *rhs_arr;
  float *r_arr, *p_arr, *q_arr;
  float *a_arr, *b_arr, *c_arr;
  float x,y,diff;
  
  int i, j;
  
  h_arr = (float *)malloc((arr_size-1)*sizeof(float));
  di_arr = (float *)malloc((arr_size-2)*sizeof(float)) ;
  rhs_arr = (float *)malloc((arr_size-2)*sizeof(float)) ;
  r_arr = (float *)malloc((arr_size-2)*sizeof(float)) ;  
  p_arr = (float *)malloc((arr_size-2)*sizeof(float)) ;  
  q_arr = (float *)malloc((arr_size-2)*sizeof(float)) ;  
  a_arr = (float *)malloc((arr_size-1)*sizeof(float)) ;
  b_arr = (float *)malloc(arr_size*sizeof(float)) ;
  c_arr = (float *)malloc((arr_size-1)*sizeof(float)) ;  

  i=0;
  while (i <= arr_size-1)
    { 
      h_arr[i]=x_arr[i+1]-x_arr[i];   
      i++;
    } 
  
  i=0;
  di_arr[0]=3*h_arr[0]+2*h_arr[1];
  di_arr[arr_size-3]=2*h_arr[arr_size-2]+3*h_arr[arr_size-1];       
  i++;
  
  while (i<=arr_size-4)
    {
      di_arr[i]=2*(h_arr[i]+h_arr[i+1]);
      i++;
    }
  
  i=0;
  while (i<=arr_size-3) 
    {
      rhs_arr[i]=3*((y_arr[i+2]-y_arr[i+1])/h_arr[i+1]-(y_arr[i+1]-y_arr[i])/h_arr[i]);
      i++;
    }
  
  i=0;
  p_arr[i]=di_arr[0];
  q_arr[i]=h_arr[1];
  r_arr[i]=rhs_arr[0];
  i++;
  q_arr[arr_size-3]=0;
  
  
  while (i<=arr_size-3)
    {
      p_arr[i]=h_arr[i]*q_arr[i-1]-di_arr[i]*p_arr[i-1];
      
      if (i<arr_size-3)
	q_arr[i]=-h_arr[i+1]*p_arr[i-1];
      r_arr[i]=h_arr[i]*r_arr[i-1]-rhs_arr[i]*p_arr[i-1];        
      i++;
    }        
  
  i=0;
  
  b_arr[arr_size-2]=r_arr[arr_size-3]/p_arr[arr_size-3];
  i=arr_size-3;
  while (i>=1)
    {
      b_arr[i]=(r_arr[i-1]-q_arr[i-1]*b_arr[i+1])/p_arr[i-1];
      i--;
    }
  
  b_arr[0]=b_arr[1];
  b_arr[arr_size-1]=b_arr[arr_size-2];
  
  
  i=0;
  while (i<=arr_size-2)
    {
      c_arr[i]=((y_arr[i+1]-y_arr[i])/h_arr[i])-(h_arr[i]*(b_arr[i+1]+2*b_arr[i])/3);
      a_arr[i]=(b_arr[i+1]-b_arr[i])/(3*h_arr[i]);		i++;
    }
  
  i=0;	
  
  while (i<=arr_size-2)
    {
      printf("%.8f %.8f %.8f %.8f %.8f %.8f\n",x_arr[i],y_arr[i],a_arr[i],b_arr[i],c_arr[i],y_arr[i]);
      i++;
    }
  
  printf("Next are approximated results using splines\n");
  for(i=0; i<=arr_size-3; i++)
    {
      x = (x_arr[i+1] + x_arr[i])/2;
      diff=x-x_arr[i];
      y=pow(diff,3)*a_arr[i]+pow(diff,2)*b_arr[i]+diff*c_arr[i]+y_arr[i];
      printf("%.8f  %.8f\n",x,y);
    }
}
/*end of spline function*/

/*==============================================*/

void error_check( int arr_size)
{
  
  float a,b,c,d,x1,x2,y,e,ans,diff;
  int i,j;
  
  e = 5.0 ;
  /* printf ("Please enter a value of x for computing y. In this particular example, please let x be in (0.0, 10.0)!\n"); */
  /* scanf("%f",&e); */

  i=0;
  j=0;
  scanf("%f",&x1);
  while (j==0)
    {
      i++;
      scanf("%f",&y);
      scanf("%f",&a);							              			
      scanf("%f",&b);	
      scanf("%f",&c);	
      scanf("%f",&d);	
      scanf("%f",&x2);	
      if (((e>=x1)&&(e<x2))||(i==arr_size))
	j=1;
      else 
	x1=x2;
    }
  
  diff=e-x1;
  ans=pow(diff,3)*a+pow(diff,2)*b+diff*c+d;
  printf("Answer: %f\n",ans);
  printf(" x = %.4f\n y = %.4f\n",x1,y);
}

/*end of error_check function*/
/*==============================================*/	

