/*From almulla Thu Sep 30 11:22:20 1993
/*From: Mohammed ALMULLA <almulla@binkley.cs.mcgill.ca>
/*To: kadima@binkley.cs.mcgill.ca

/************************************************************************/
/*									*/
/*			M c G i l l  U n i v e rs i t y			*/
/*			-------------------------------			*/
/*									*/
/*									*/
/*	  		  School of Computer Science			*/
/*									*/
/*									*/
/*			  Master Thesis Program For			*/
/*									*/
/*									*/
/*				   T H E				*/
/*	   T R A V E L I N G   S A L E S M A N   P R O B L E M		*/
/*									*/
/*									*/
/*				    B Y					*/
/*									*/
/*			Name  : Almulla Mohammed A.			*/
/*				ID #:8202665AL				*/
/*									*/
/************************************************************************/

#include <sys/types.h>
#include <malloc.h>
#include <sys/times.h>
#include <stdio.h>
#include <math.h>
#define false 0
#define true 1       
#define maxsize 16
#define maxreal 99999999.0

/************************************************************************/
/*									*/
/*	GLOBAL VARIABLES FOR THE MAIN PROGRAM AND ALL THE PROCEDURES	*/
/*									*/
/* maxsize: THE PROGRAM IS DESIGNED TO RUN A PROBLEM OF A MAXIMUM OF 15 */
/*	CITIES IN THE NETWORK. YOU CAN EXTEND THE MAXSIZE BUT THIS IS   */
/* 	UNRECOMMENDED BECAUSE THIS ALGORITHM IS NOT DESIGN TO RUN VERY  */
/*	LARGE SCALE TRAVELLING SALESMAN PROBLEMS.			*/
/*									*/
/* maxreal: THIS IS A REAL NUMBER TO REPRESENTS THE QUANTITY INFINITY   */
/*	WHICH IS THE DISTANCE TRAVELLED BETWEEN CITY i AND ITSELF. THIS */
/*	MEANS THAT ONE CAN NOT REVISIT THE CITY IF HE IS IN IT.		*/
/*									*/
/* n : NUMBER OF CITIES IN THE NETWORK. THESE n CITIES ARE DISTRIBUTED  */
/*	UNIFORMALLY IN A UNIT SQUARE. 					*/
/*									*/
/* startcity: THE CITY AT WHICH THE TOUR WILL START.			*/
/*									*/
/* onecity: FLAG TO INDICATE WHETHER WE WANT TO TEST A PARTICULAR CITY  */
/*	AS THE STARTING CITY, OR TRY ALL POSSIBILITIES (THAT IS TO TRY  */
/* 	EACH AND EVERY CITY AS THE STARTING CITY. THIS HAD PROVEN TO    */
/*	HAVE AN EFFECT ON THE OPTIMALITY OF THE SOLUTION.		*/
/*									*/
/* all_levles: ANOTHER FLAG TO INDICATE WHETHER WE WANT TO PROPOGATE THE*/
/*	NON GREEDY STEP(S) DOWN IN THE TREE, OR WE WISH TO TEST THE     */
/*	NON-GREEDY STEP(S) AT A PARTICULAR LEVEL OF THE TREE.		*/
/*									*/
/* debug: A THIRD FLAG TO INDICATE WHETHER WE WANT TO PRINT THE TREE AS */
/*	THE SOLUTION IS COMING ALONG.					*/
/*									*/
/* degree: THE DEGREE OF THE NON-GREEDY HEURISTIC THAT WE WISH TO 	*/
/*	INVOKE IN SOLVING THIS PROBLEM.					*/
/*									*/
/* minbd: IS THE ANSWER THAT THE HEURISTIC SUPPOSED TO COME UP WITH     */
/*	REGADLESS OF IT'S BEING OPTIMAL OR NOT.				*/
/*									*/
/* starttime, duration, finishtime: ALL OF THESE ARE VARIAVLES USED TO  */
/*	TIME THE EXECUTION OF THE PROGRAM.				*/
/*									*/
/* matrix: THE COST MATRIX WHICH CONTAIN THE COST OF GOING FROM ANY CITY*/
/*	TO ANY OTHER CITY. THE VALUES FOR THIS MATRIX WILL BE READ FROM */
/*	EXTERNAL FILES (CONTAINING REAL DISTANCES) OBTAINED FROM A 	*/
/*	RANDOM NUMBER GENERATOR THAT WILL BE APPENDEXED TO THE PROGRAM. */
/*									*/
/* headn, goaln: THESE ARE TWO GLOBALS NODES USED TO GENERATE THE 	*/
/* 	TSPROBLEM AND SOLVE IT AS WELL.					*/ 
/*									*/
/************************************************************************/

int iter, startcity, n, totalnodes;
int onecity, all_levels, debug;
int degree, level;
float minbd;
float starttime, duration, finishtime;
double matrix[maxsize][maxsize];
struct node {
       int visited[maxsize], mark[maxsize], tourlength;
       float bound, cost;
       } headn, goaln, *temp1;
FILE *fopen(), *fp;
char *name;

/************************************************************************/
/*                                                                   	*/
/*                   T H E    M A I N    P R O G R A M             	*/
/*                                                                   	*/
/************************************************************************/

main()
{
    name = "result";
/*    fp = fopen(name, "a");*/
    debug = true;
    read_input();
    get_strategy();
    print_solution();
/*    check_solution();*/
/*    fclose(fp);*/
}
/************************************************************************/
/*                                                                   	*/
/*	check_solution: WHEN THE PROGRAM IS FINISHED FROM CALCULATING   */
/* A SOLUTION TO THE TRAVELLING SALESMAN PROBLEM, THE USER HAS THE 	*/
/* ABILITY TO CHECK THE SOLUTION BY INTERING THE TOUR PROPOSED BY THE   */
/* ALGORITHM AND THE CHECK_SOLUTION WILL VERIFY WHETHER THE SOLUTION IS */
/* TRUELY CORRECT OR NOT. THIS WILL BE MEANLY USED FOR DEBUGGING 	*/
/* PURPOSES.								*/
/*                                                                   	*/
/* Global Variables: MATRIX, N.						*/
/*                                                                   	*/
/* Procedures called: NONE.						*/
/*                                                                   	*/
/************************************************************************/

check_solution()
{
	int sol[maxsize], i;
	int check = true;
	float result=0;
	if (check)
	{
		for (i=1; i<=n; ++i)
			scanf("%d", &sol[i]);
		for (i=1; i<n; ++i)
			result += matrix[sol[i]][sol[i+1]];
		result += matrix[sol[n]][sol[1]];
		printf("The verified result is = %.2f\n", result);
	};
}

/************************************************************************/
/*                                                                   	*/
/*	PRINT_SOLUTION: WILL PRINT THE OPTIMAL / SUB-OPTIMAL COST FOUND */
/* FOR THE TOUR, AND THE TOUR WHICH GIVES THAT SOLUTION STARTING FROM   */
/* THE STARTCITY AND BACK TO IT.					*/
/*                                                                   	*/
/* Global Variavles: minbd, goaln.					*/
/*									*/
/* Procedures called: printtime().					*/
/*									*/
/************************************************************************/

print_solution()
{
	int i;
/*	fprintf(fp, "%.2f \n", minbd);*/
	printf("\nThe Tour cost is : %.2f \n", minbd);
	for (i=1; i<=n; ++i)
		printf("%d ",goaln.visited[i]);
	printf("%d \n", goaln.visited[1]);
	printtime();
}

/************************************************************************/
/*                                                                   	*/
/*	PDUMP: SOMETIMES YOU ARE GIVEN A POINTER TO A NODE AND YOU ARE  */
/* TOLD TO DUMP THE CONTENT OF THAT NODE. BY DUMPING THE CONTENT ONE    */
/* NEEDS TO PRINT THE TOUR PERFORMED SO FAR, ALONG WITH THE TOURLENGTH  */
/* AND THE COST OF THAT NODE. THE COST IS OBTAINED BY CALCULATING THE   */
/* ACTUAL COST FROM THE STARTING CITY TO THE CURRENT CITY PLUS AN       */
/* ESTIMATE FOR THE COST OF THE REMAINING SUBSET OF CITIES IN THE       */
/* NETWORK THAT IS YET TO BE VISITED.					*/
/*                                                                   	*/
/* Global Variavles: NONE.						*/
/*									*/
/* Procedures called: NONE.						*/
/*									*/
/************************************************************************/

pdump(head)
struct node *head;
{
	int i;
	for (i=1; i<= n; ++i)
		printf("%d ",head->visited[i]);
	printf("\n");
	printf("%d\n",head->tourlength);
	printf("%.2f\n",head->bound);
}

/************************************************************************/
/*                                                                   	*/
/*	DUMP: IS JUST LIKE PDUMP, AND WILL DO THE SAME THING, BUT WE    */
/* GIVEN THE NODE THAT WE WISH TO DUMP INSTEAD OF A POINTER TO THAT     */
/* NODE. NOTE THAT THE LOCATION FROM WICH THIS PROCEDURE CAN BE CALLED  */
/* IS SOMEWHAT DIFFERENT THAN THE LOCATION FROM WHICH PDUMP IS CALLED.  */
/*                                                                   	*/
/* Global Variavles: NONE.						*/
/*									*/
/* Procedures called: NONE.						*/
/*									*/
/************************************************************************/

dump(head)
struct node head;
{
	int i;
	for (i=1; i<= n; ++i)
		printf("%d ",head.visited[i]);
	printf("\n");
	printf("%d\n",head.tourlength);
	printf("%.2f\n",head.bound);
}

/************************************************************************/
/*                                                                   	*/
/*	GET_STRATEGY: THIS PROCEDURE IS VERY CRITICAL IN THE EXECUTION  */
/* OF THIS PROGRAM. IN THIS PROCEDURE THE USER MUST SPECIFY THE KIND OF */
/* HEURISTIC TO BE INVOKED, BUT FIRST HE/SHE MUST PROVIDE SOME VERY     */
/* IMPORTANT PARAMETERS. HERE IS A LIST OF THOSE PARAMETERS:		*/
/*									*/
/*   1 - DEGREE: AN INTEGER THAT IMPLICATE THE DEGREE OF THE GREEDY     */
/*	         HEURISTIC.						*/
/*									*/
/*   2 - ALL_LEVELS: THIS IS A BOOLEAN FLAG TO TELL THE COMPUTER	*/
/*	         WHETHER TO PROPOGATE THE NON-GREEDY STEP DOWN THE      */
/*		 LEVELS OF THE SEARCH TREE.				*/
/*									*/
/*   3 - ONE_CITY: SOMETIMES THE STARTING CITY MIGHT MAKE A DIFFERENCE  */
/* 		 RETURNING THE OPTIMAL SOLUTION OR A CLOSE TO THE       */
/*		 OPTIMAL SOLTION. THIS PROGRAM GIVES THE USER THE 	*/
/*		 ABILITY TO CHOOSE A PARTICULAR CITY TO BE THE STARTING */
/*		 CITY (BY SETTING THE FLAG "ONECITY" ON) OR TO TRY ALL  */
/*		 THE CITIES AS CANDIDATES FOR THE STARTING CITY (BY     */
/*		 SETTING IT OFF.					*/
/*									*/
/*	ONE THING TO NOTICE IS THAT GREEDY HEURISTIC OF DEGREE ZERO IS  */
/* NOT THE SAME AS THE REST OF THE GREEDY HEURISTICS, SINCE IT HAS NO   */
/* NON-GREEDY STEP TO PROPOGATE DOWN, SO THE RUN WILL BE IN ONE PASS    */
/* ONLY, UNLIKE THE OTHER GREEDY HEURISTICS WHERE ONE HAS TO PROPOGATE  */
/* THE NON-GREEDY STEP.							*/
/*									*/
/*                                                                   	*/
/* Global Variavles: DEGREE, ALL_LEVELS, ONECITY, STARTCITY, HEADN,	*/
/*		     MINBD, STARTTIME, FINISHTIME, STARTTIME, DURATION, */
/*		     FINISHTIME.					*/
/*									*/
/* Procedures called: SCANF(), CPU_TIME(), ONE_CITY_SOLUTION(),		*/
/*		     ALL_CITIES_SOLUTION(), HEURISTIC_SOLUTION().	*/
/*									*/
/************************************************************************/

get_strategy()
{
	float one_city_solution(), all_cities_solution(),
	heuristic_solution(), CPU_time();
	degree = 2;
	all_levels = true;
	onecity = true;
	starttime = CPU_time();
	if ((degree == 0) && (onecity))
		minbd = one_city_solution();
	else if (degree == 0)
		minbd = all_cities_solution();
	     else   
		minbd = heuristic_solution();
	finishtime = CPU_time();
	duration = finishtime - starttime;
}

/************************************************************************/
/*									*/
/*	ONE_CITY_SOLUTION: THIS PROCEDURE MAKES A COPY OF THE HEAD NODE */
/* CREATED AT THE BEGINNIG OF THE PROBLEM WHEN READING THE MATRIX FROM  */
/* THE DATA FILE AND THEN CALL THE PROCEDURE ChildGreedExp, WHICH WILL  */
/* CONDUCT A GREEDY EVALUATION AT EVERY LEVEL OF THETREE FROM THE ROOT  */
/* TO THE LEAVES OF THE TREE.						*/
/*                                                                   	*/
/* Global Variavles: HEADN, GOALN,					*/
/*									*/
/* Procedures called: CHILDGREEDEXP(), MAKECOPY().			*/
/*									*/
/************************************************************************/

float one_city_solution()
{
	float ChildGreedExp();
	goaln = headn;
	return( ChildGreedExp(&goaln,1) );
}

/************************************************************************/
/*									*/
/*	ALL_CITIES_SOLUTION: IF THERE ARE N CITIES IN THE NETWORK AND   */
/* STARTING FROM CITY 1 TO CITY N TAKING EACH AS THE STARTING CITY, TRY */
/* TO FIND THE SOLUTION OF THE GREDDY HEURISTIC OF DEGREE ZERO  AND     */
/* RETURN THE MINIMUM ONE FOUND. EVERY TIME WE UPDATE THE MINIMUM BOUND */
/* WE KEEP THE WHOLE NODE WHICH GAVE THAT MINIMUM BOUND. BY THE WHOLE   */
/* NODE I MEAN THE TOUR TAKEN ALONG WITH THE TOUR LENGTH AND BOUND.     */
/*                                                                   	*/
/* Global Variavles: HEADN, GOALN, MINBD.				*/
/*									*/
/* Procedures called: CHILDGREEDEXP(), MAKECOPY()			*/
/*									*/
/************************************************************************/

float all_cities_solution()
{
	float citymin;
	int city;
	struct node optimum;
	for (city=1;city<=n;++city)
	{
		startcity = city;
		optimum = headn;
		optimum.visited[1] = startcity;
		optimum.mark[startcity] = true;
		citymin = ChildGreedExp(&optimum, 1);
                printf("%.2f   %d\n", citymin, city);
		if (citymin < minbd)
		{
			minbd = citymin;
		};
	};
	return(minbd);
}

/************************************************************************/
/*									*/
/*	HEURISTIC_SOLUTION: WHENEVER THE DEGREE ID NOT ZERO WE HAVE ONE */
/* OR MORE NON-GREEDY STEPS TO BE PERFORMED STARTING AT PLY 1 THEN 2 &  */
/* SO ON UNTIL REACH PLY N-1 (WHENEVER IT'S POSSIBLE). AT THE BEGINNING */
/* OF THIS PROCEDURE, THE PROGRAM ASKS IF YOU WANT TO PROPOGATE THE     */
/* NON-GREEDY STEP DOWN IN THE TREE, OR WHETHER YOU WANT TO CHOOSE ONE  */
/* PARTICULAR PLY AT WHICH TO PERFORM THE NON-GREEDY STEP(S). IF YOU    */
/* CHOOSE TO PROPOGATE IT, EVERY PASS WILL GIVE US A MINIMUM BOUND, THE */
/* PROCEDURE THEN RETURNS THE MINIMUM OF THESE MINIMUM BOUNDS. WHEREAS  */
/* IF YOU CHOOSE ONE PARTICULAR PLY SAY PLY i, THEN THIS PROCEDURE WILL */
/* PERFORM THE GREEDY HEURISTIC FROM PLY 1 UP TO PLY i-1, AND STARTING  */
/* FROM PLY i UP TO PLY N-1 PROPOGATE THE NON-GREEDY STEP(S).		*/
/*                                                                   	*/
/* Global Variavles: DEGREE, N, MINBD.					*/
/*									*/
/* Procedures called: SCANF(), PRINTF(), HEURISTIC().			*/
/*									*/
/************************************************************************/

float heuristic_solution()
{
	float levelmin, heuristic();
	int level = 1;
	if (all_levels == false)
	{
/*		scanf("%d",&level);*/
		level = 1;
		minbd = heuristic(level);
	}
	else
		while ((level < n) && (level+degree <= n))
		{
			levelmin = heuristic(level);
/*			if (debug) 
				printf("the level bound is %.2f\n\n",levelmin);
*/			if (minbd > levelmin)
				minbd = levelmin;
			++level;
		};
	return(minbd);
}

/************************************************************************/
/*									*/
/*	HEURISTIC: TO THIS PROCEDURE WE PASS THE PARAMER NUM WHICH WILL */
/* TELL THE COMPUTETR AT WHICH PLY WE WISH TO PERFORM THE NON-GREEDY    */
/* STEP(S) IF ANY. FOR ALL THE PLIES PRECEEDING PLY NUM, LET THE        */
/* HEURISTIC PERFORM A GREEDY EVALUATION [THAT IS AT EACH PLY WE HAVE A */
/* GENERATE ALL THE CHILDREN OF THIS NODE AND CHOOSE THE NODE WITH THE  */
/* MINIMUM COST AND USE THIS NODE AS THE PARENT OF NEXT PLY. REPEATE    */
/* THIS UNTIL YOU REACH PLY NUM, WHERE THE PROCEDURE CALLS ANOTHER      */
/* PROCEDURE NAMED NG_step.						*/
/*                                                                  	*/
/* Global Variavles: HEADN.						*/
/*									*/
/* Procedures called: CALLOC(), MAKECOPY(), PDUMP(), GREED(), NG_STEP() */
/*									*/
/************************************************************************/

float heuristic(num)
int num;
{
	float localmin, totalmin, NG_step();
	struct node *greed();
	int depth=1,child=1;
	struct node *live, copyptr;
	totalmin = maxreal;
	live = (struct node *) calloc (1,sizeof(struct node));
	*live = headn;
/*	pdump(live);*/
	while (depth < num)
	{
		live = greed(live);
		++depth;
	};
	totalmin = NG_step(live, depth, 1);	
	return(totalmin);
}

/************************************************************************/
/*                                                                  	*/
/*	NG_STEP: THIS PROCEDURE RECEIVES THREE PARAMETERS, A NODE CALLED*/
/* LIVE, DEPTH (AN INTEGER) AT WHICH TO PERFORM THE NON-GREEDY STEP(S), */
/* AND ITER (AN INTEGER) TO TELL AT WHICH ITERATION WE ARE RIGHT NOW.   */
/* YES YOU GUSSED IT THIS PROCEDURE IS A RECURSIVE ONE, IT CALLES ITSELF*/
/* NUMBER OF TIMES EQUAL TO THE DEGREE OF THE GREEDY WE ARE INVOKING.   */
/* FOR EXAMPLE WHEN WE SAY GREEDY OF DEGREE 3, WE MEAN THAT GIVEN A     */
/* PARTICULAR NODE AND FOR THREE PLIES WE GENERATE ALL THE CHILDREN AND */
/* TEST THEM ALL.							*/
/*                                                                  	*/
/* Global Variavles: DEGREE, N.						*/
/*									*/
/* Procedures called: PISINTOUR(), PRINTF(), PMAKECOPY(),               */
/*		     CHILDGREEDEXP().					*/
/*									*/
/************************************************************************/

float NG_step(live, depth, iter)
struct node *live;
int depth, iter;
{
	float localmin, totalmin, ChildGreedExp();
	int child, temp, i, j, dp;
	struct node copyptr, cop1, *cop2;
	totalmin = maxreal;
	++depth;
	child = 1;
	temp = iter;
	while (child <= n)
	{
		if (live->mark[child] == false)
		{
			copyptr = *live;
			copyptr.visited[copyptr.tourlength+1] = child;
			copyptr.mark[child] = true;
			copyptr.tourlength = copyptr.tourlength+1;
			copyptr.cost += matrix[copyptr.visited[copyptr.tourlength-1]][copyptr.visited[copyptr.tourlength]];
			if ((iter < degree) && (degree < n))
			{
				++iter;
				cop1 = copyptr;
/*				dump(cop1);*/
				dp = depth;
				localmin = NG_step(&copyptr, depth, iter);
				depth = dp;
				if (totalmin > localmin)
					totalmin = localmin;
				iter = temp;
				dp = depth;
				i = 1;
				while ( depth <= n-2 )
				{
					cop2 = (struct node *) calloc (1,sizeof(struct node));
					*cop2 = cop1;
/*					pdump(cop2);*/
					depth = dp;
					for (j=1; j<=i; ++j)
					{
						cop2 = greed(cop2);
						++depth;
					};
/*					pdump(cop2);*/
					localmin = NG_step(cop2, depth, iter);
					if (totalmin > localmin)
						totalmin = localmin;
					++i;
				};
				depth = dp;
			}
			else if (copyptr.tourlength != n)
			{
				localmin = ChildGreedExp(&copyptr, depth);
				if (totalmin > localmin)
					totalmin = localmin;
			}
			else
			{
				localmin = 0;
				for (i=1; i<=n-1; ++i)
					localmin += matrix[copyptr.visited[i]][copyptr.visited[i+1]];
				localmin += matrix[copyptr.visited[n]][copyptr.visited[1]];
				if (totalmin > localmin)
					totalmin = localmin;
/*				if (minbd > totalmin)
					goaln = copyptr;*/
			};
		};
		++child;
	};
	return(totalmin);
}
		
/************************************************************************/
/*                                                                  	*/
/*	ISINTOUR: SOMETIMES WE AARE GIVEN A NODE AND WE DO NOT KNOW IF  */
/* A PARTICULAR CITY HAS BEEN VISITED OR NOT YET!. THIS BOOEAN PROCEDURE*/
/* IS CALLED WITH THE NODE AND AN INDEX TO THE CITY TO BE TESTED. IF THE*/
/* CITY HAS BEEN VISITED ALREDY WE RETURN TRUE, FALSE OTHERWISE.	*/
/*									*/
/* GLOBAL VARIABLES: NONE.						*/
/*									*/
/* PROCEDURES CALLED : NONE.						*/
/*                                                                  	*/
/************************************************************************/

IsinTour(node, a)
struct node node;
int a;
{
	int i=1, found=false;
	while((i <= node.tourlength) && (node.visited[i] != 0) && (found == false))
	{
		if (a == node.visited[i])
			found = true;
		++i;
	};
	return(found);
}

/************************************************************************/
/*                                                                  	*/
/*       PISINTOUR: SOMETIMES WE ARE GIVEN A POINTERTO A NODE AND ASK IF*/
/* A PARTICULAR CITY HAS BEEN VISITED OR NOT YET!. THIS BOOEAN PROCEDURE*/
/* IS CALLED WITH THE NODE AND AN INDEX TO THE CITY TO BE TESTED. IF THE*/
/* CITY HAS BEEN VISITED ALREDY WE RETURN TRUE, FALSE OTHERWISE.	*/
/*									*/
/* GLOBAL VARIABLES: NONE.						*/
/*									*/
/* PROCEDURES CALLED : NONE.						*/
/*                                                                  	*/
/************************************************************************/

pIsinTour(node, a)
struct node *node;
int a;
{
	int i=1, found=false;
	while((i <= node->tourlength) && (node->visited[i] != 0) && (found == false))
	{
		if (a == node->visited[i])
			found = true;
		++i;
	};
	return(found);
}
/************************************************************************/
/*									*/
/*	GREED: THIS PROCEDURE RECEIVES A NODE CALLED ELEM AS A          */
/* PARAMETER. IN ELEM THERE IS A LIST OF ALL THE CITIES WHICH WE VISITED*/
/* ALREADY PLUS THE TOUR LENGTH AND COST SOFAR. NOW STARTING FROM CITY  */
/* 1 LOOK FOR THOSE CITES THAT ARE NOT IN THE TOUR YET, GO VISIT THEM   */
/* AND CREATE A COPY OF THE NODE ELEM WITH THE NEW CITY ADDED TO THE    */
/* TOUR AND KEEP TRACK OF THE CITY WHICH GIVES THE MINIMUM COST AMONG   */
/* THOSE NEWLY CREATED CITIES.						*/
/*									*/
/* GLOBAL VARIABLES: TEMP1, N.						*/
/*									*/
/* PROCEDURES CALLED : PISINTOUR(), PMAKECOPY(), GETCOST(), DUMP(),	*/
/*		     MAKECOPY(), PRINTF(), CALLOC().			*/
/*									*/
/************************************************************************/

struct node *greed(elem)
struct node *elem;
{
	double getcost();
	double getbound();
	float localmin=maxreal;
	struct node copyptr, temp;
	int child=1,index=1, x;
	while (child <= n)
	{
		if (elem->mark[child] == false)
		{
			++totalnodes;
			copyptr = *elem;
			x = copyptr.tourlength+1;
			copyptr.visited[x] = child;
			copyptr.mark[child] = true;
			copyptr.tourlength = x;
			copyptr.cost += matrix[copyptr.visited[x-1]][copyptr.visited[x]];
			copyptr.bound = getbound(&copyptr);
/*			printf("%d   %.2f\n", child, copyptr.bound);
			dump(copyptr);*/
			if (localmin > copyptr.bound)
			{
				localmin = copyptr.bound;
				temp = copyptr;
			};
		};
		++child;
	};
/*        printf("\n");*/
	temp1 = (struct node *) calloc (1,sizeof(struct node));
	*temp1 = temp;
	return(temp1);
}
/************************************************************************/
/*									*/
/* 	CPU_TIME: THIS PROCEDURE IS C_SHELL PROCEDURE WHICH THE C LIB   */
/* TO GET THE TIME OF THE SYSTEM AND RETURNS IT IN SECONDS AND A REAL   */
/* NUMBER. THE USER MUST CONVERT IT INTO HOURS AND MINUTES IN NECESSARLY*/
/*									*/
/* GLOBAL VARIABLES: NONE.						*/
/*									*/
/* PROCEDURES CALLED : TIMES().						*/
/*									*/
/************************************************************************/

float CPU_time()
{
    static struct tms buffer;
    times(&buffer);
    return(buffer.tms_utime/60.0);
}

/************************************************************************/
/*									*/
/*     IN READIN I INITIALIZE THE ROOT NODE, THAT IS NO CITIES IN THE   */
/*     TOUR BUT CITY A AND ALL OTHER CITIES ARE VALID POSSIBILITIES	*/
/*     THEN I READ IN THE MATRIX ROW BY ROW.				*/
/*									*/
/*     Global Variables  : buffer					*/
/*									*/
/*     Procedures Called : times.					*/
/*									*/
/************************************************************************/

read_input()
{
   float initial_bound();
   int i, j ;
   double getbound();

   n = 10;
   for (i=1; i<=n; ++i)
       for (j=i; j<=n; ++j)
       {
	    if (i==j) 
 		matrix[i][j] = maxreal;
	    else
	    {
                scanf("%lf", &matrix[i][j]);
                matrix[j][i] = matrix[i][j];
	    }
	}
/*   if (debug)
        for (i=1; i<=n; ++i)
        {
	     printf("(%d)  ",i);
	     for (j=1; j<=n; ++j)
	    	   printf("%.2f   ",matrix[i][j]);
	     printf("\n\n");
	};*/
   minbd = maxreal;
   startcity = 1;
   for (i = 1 ; i <= n ; ++i)
   {
	     headn.mark[i] = false;
             headn.visited[i] = false;
   };
   headn.visited[1] = startcity;
   headn.mark[startcity] = true;
   headn.tourlength = 1;
   headn.bound = 0;
   headn.cost  = 0;
/*   headn.bound = getbound(&headn);*/
   headn.bound = getbound(&headn);
   printf("Initial bound = %.2f\n", headn.bound);
   ++totalnodes;
}

/************************************************************************/
/*									*/
/*	ChildGreedExp: WE SEND TO THIS PROCEDURE A GIVEN NODE WITH THE  */
/* DEPTH OF THAT NODE IN THE SOLUTION TREE. NOW STARTING FROM THE DEPTH */
/* LEVEL OF THAT NODE AND UP TO THE LAST LEVEL OF THE TREE (THAT IS n-1)*/
/* WE DO A GREEDY EVALUATION, THAT IS AT EACH LEVEL GENERATE ALL THE    */
/* CHILDREN AND COMPUTE THEIR COSTS, FIND THE NODE WITH THE MINIMUM     */
/* COST AND CHOOSE IT FOR THE NEXT ITERATION AND SO ON.	AT THE END WE   */
/* RETURN THE BOUND OF THE LAST NODE FOUND.				*/
/*									*/
/* Global Variables: GOALN, N.						*/
/*									*/
/* Procedures Called: GREED, PMAKECOPY.					*/
/*									*/
/************************************************************************/

float ChildGreedExp(elem, depth)
struct node *elem;
int depth;
{
	struct node *greed();
	while (depth <= n-1)
	{
		elem = greed(elem);
		++depth;
	};
	if (elem->bound < minbd)
	{
/*		goaln = *elem;
		minbd = elem->bound;*/
	};
	return(elem->bound);
}

/************************************************************************/
/*									*/
/*	 TO GET THE COST OF A NODE, FIRST I CALCULATE THE COST OF THE 	*/
/* CITIES THAT ALREADY BEEN VISITED, AND FOR THE REMAINING CITIES	*/
/* WE HAVE TWO CASES, EITHER ONE MORE CITY LEFT OUT IN THE NETWORK	*/
/* FOE WHICH I HAVE A DIFFERENT RULE (CALL THE DIFF_RULE FUNCTION) 	*/
/* OR WE HAVE MORE THAN ONE CITY TO VISIT, IN WHICH CASE I CALCULATE	*/
/* BEST PATH IN AND OUT OF EACH OF THESE CITIES DIVIDED BY 2 (AVGED)	*/
/* AND DON'T FORGET THE END CITIES IN THE CHAIN WE HAVE TO GET THE	*/
/* BEST PATH GOING IN AND OUT OF EACH OF THE (CALL END_CITIES FUNC)	*/
/*									*/
/* Global Variables  : MATRIX, N.					*/
/*									*/
/* Procedures Called : DIFFRULE, MINLINE, ENDCITIES, ISINTOUR.		*/
/*									*/
/************************************************************************/

float getbound(node)
struct node *node;
{
  double min1,min2,nodebound, mm1=0, mm2=0;
  int i,j,j1,lastcity, x, y;

  if (node->tourlength == n )
  {
	nodebound = node->cost + matrix[node->visited[node->tourlength]][startcity];
	if (nodebound < minbd)
		goaln = *node;
  }
  else  if (node->tourlength == n - 1 )
  {
    lastcity = 1;
    while ((node->mark[lastcity]) && (lastcity <= n))
      ++lastcity;
    nodebound = node->cost + matrix[node->visited[node->tourlength]][lastcity] + matrix[lastcity][startcity];
  }
  else
  {
    nodebound = 0;
    for (i=1; i<=n; ++i)
        if (node->mark[i] == false) /*(pIsinTour(node, i) == false)*/
        {
           if (matrix[i][startcity] < matrix[i][node->visited[node->tourlength]])
              min1 = matrix[i][startcity];
           else
              min1 = matrix[i][node->visited[node->tourlength]];
           min2 = maxreal;
           for (j=1; j<=n; ++j)
               if (node->mark[i] == false) /*(pIsinTour(node, i) == false)*/
               {
                   if (matrix[i][j] < min1)
       		   {
	              min2 = min1;
        	      min1 = matrix[i][j];
                   }
                   else
              	      if (matrix[i][j] < min2)
             	            min2 = matrix[i][j];
              }
          nodebound += min1 + min2;
        }
    min1 = maxreal;
    for (i=1; i<=n; ++i)
	      if ((node->mark[i] == false) /*(pIsinTour(node, i) == false)*/ && (min1 > matrix[startcity][i]))
	      {
	          min1 = matrix[startcity][i];
	          j = i;
	      }

    mm1 +=min1;
    min1 = maxreal;
    for (i=1; i<=n; ++i)
	    if ((node->mark[i] == false) /*(pIsinTour(node, i) == false)*/ && (min1 > matrix[node->visited[node->tourlength]][i]) && (i!=j))
	    {
        	min1 = matrix[node->visited[node->tourlength]][i];
	        j1 = i;
	    };

    mm1 += min1;

    min1 = maxreal;
    for (i=1; i<=n; ++i)
	      if ((node->mark[i] == false) /*(pIsinTour(node, i) == false)*/ && (min1 > matrix[node->visited[node->tourlength]][i]))
	      {
        	  min1 = matrix[node->visited[node->tourlength]][i];
	          j = i;
	      }

    mm2 +=min1;
    min1 = maxreal;
    for (i=1; i<=n; ++i)
    	    if ((node->mark[i] == false) /*(pIsinTour(node, i) == false)*/ && (min1 > matrix[startcity][i]) && (i!=j))
	    {
        	min1 = matrix[startcity][i];
	        j1 = i;
	    };

    mm2 += min1;
    if ( mm1 < mm2 )
		nodebound += mm1;
    else
		nodebound += mm2;
    nodebound = nodebound/2.0 + node->cost;
  } 
  return(nodebound);
}

/************************************************************************/
/*									*/
/*	PRINTTIME: THE TIMER FUNCTION GAVE US THE TIME IN SECONDS, BUT  */
/* IT WILL BE CONFUSING IF THE TIME WAS SOMETHING LIKE 5437 SECONDS. SO */
/* I FIND IT IMPORTANT TO CONVERT THE TIME INTO HOURS,MINUTES, AND 	*/
/* SECOND. tHIS WILL BE QUITE USEFULL WHEN WE SOLVE A PROBLEM OF 10 	*/
/* CITIES USING A GREEDY HEURISTIC OF DEGREE 5 OR 6 (LET'S SAY).        */
/*									*/
/* Global Variables  : DURATION.					*/
/*									*/
/* Procedures Called : None.						*/
/*									*/
/************************************************************************/

printtime()
{
	int x, y;

	printf("Total nodes generated = %d\n", totalnodes);

/******We comment this, so that the outputs would not differ , Ana
	printf("Number of nodes generated per second = %.1f\n", (float)(totalnodes) / duration); */
	x = 0;
	y = 0;
	x = duration / 60;
	while (duration >= 60)
		duration = duration - 60;
	if (x >= 60)
	{
		y = x / 60;
		x = x % 60;
	};
/* We comment this , so that the output does not differ between executions, Ana
	printf("Time taken by the tour is %d: %d: %.2f\n",y,x,duration);*/
}



