#include <malloc.h> 
/* the name was converted to pgm6.c */

/**********************************************************************/
/* THIS PROGRAM IS COPIED FROM ADVANCED C PROGRAMMING ON THE IBM PC   */
/* This cross-reference program builds a tree of items.               */
/* Each item is a unique identifier, starting with a letter,          */
/* containing letters and digits. Also, an item associates an         */
/* arbitrarily long list of linenumbers with each unique identifier.  */
/*   The items are stored as a binary tree; see the two main data     */
/* structures <ItemType> and <NodeType>. A node contains also Pointers*/
/* to the Left and Right subtrees, where Left arbitrarily means       */
/* <Smaller> and Right means <Greater> lexiographically.              */
/*                                                                    */
/* Herbert G. Mayer, December 1987, Portland.   xref.c                */
/**********************************************************************/

#define EOF		-1	/* In some C implementation : 0 */
#define NULL 		0	/* Symbolic NULL Pointer */
#define MaxOnLine	10	/* LineNumbers per output line */
#define MaxLength	15	/* MaxLength significant chars */
				/* change also in format %15s */
#define True		1	/* any value != 0 */
#define False		0	/* Boolean False == 0 */
#define is_letter(c)	((c)>='a' && (c) <= 'z' ||(c)>='A' && (c)<='z')
#define is_letgit(c)	(is_letter(c) || c>='0' && c<='9')

  typedef struct ItemType	/* Linked list of items */
    { int	Linenum; 	/* Linenumber of this identifier */
      struct ItemType *Next;	/* Next in linked list */
    };

  typedef struct ItemType *ItemPin;

  typedef struct NodeType
    {  char	*Name;		/* identifier to be cross-ref'd */
       ItemPin	First;		/* First element in linked list */
       ItemPin	Last;		/* Last element, may be equal first */
       struct NodeType *Left;	/* subtree with smaller string */
       struct NodeType *Right;	/* subtree with greater string */
    };

    typedef struct NodeType *NodePin;

    NodePin	Root = NULL;	/* Global Tree */
    int		Linenum = 1;	/* Keeps track of linends */
    char	*Name;		/* Points to recently read identifier */
    char	NextChar;	/* recent input character */

    char GetNext()
      {  /* GetNext */ /* to count Linenum in 1 place */
	char c;
	if ( ( c = getchar() ) == '\n')
	  Linenum++;
	  /* end if*/
	  return c;
      } /* end GetNext*/

    char *GetIdent()
      { /* GetIdent */		/* store only <MaxLength> chars */
	unsigned Length = 0;	/* keep track of chars in identifier */
	char *Name;		/* points to scanned identifier */
	Name = (char*) malloc (MaxLength + 1); /* +1 for terminator*/
	do { /* Repeat statement o.k., we know first is_letter() */
	  if ( Length < MaxLength)
	    Name[Length++] = NextChar;
	    /*end if*/
	    NextChar = GetNext(); /* increment Linenumber, side-effect*/
        } while( is_letgit( NextChar));
	Name[Length] = NULL;
	return Name;		/* return Name to caller */
      } /* end GetIdent */

  ItemPin MakeItem( Linenum)
    unsigned Linenum;
    { /*MakeItem */
      ItemPin Item;
      Item = (ItemPin) malloc (sizeof(struct ItemType));/* trusting */
      if( NextChar == '\n')
	Item->Linenum = Linenum - 1;	/* linenum already incremented */
      else
        Item->Linenum = Linenum;
      /* end if */
      Item->Next = NULL;
      return Item;
    } /* end MakeItem */

  NodePin MakeId( Name)
    char *Name;
    { /* MakeId */
      NodePin Node;
      Node = (NodePin) malloc (sizeof(struct NodeType)); /* trusting*/
      Node->Name = Name;
      Node->Left = NULL;
      Node->Right = NULL;
      Node->First = MakeItem( Linenum);
      return Node;
    } /* end MakeId */

  void Search( PPRoot, Name)
    NodePin *PPRoot;
    char *Name;
    
      { /* Search */
      ItemPin temp;
      if(( *PPRoot) == NULL)
	*PPRoot = MakeId( Name); /* attach new identifier */
      else if ( strcmp( Name, (*PPRoot)->Name) < 0) /* less */
	Search( &((*PPRoot)->Left), Name);
      else if( strcmp( Name, (*PPRoot)->Name) > 0) /* greater*/
	Search( &((*PPRoot)->Right), Name);
      else { /* equal */
           temp =  (*PPRoot)->First; 
           while (temp->Next)
             temp = temp->Next;
           temp->Next = MakeItem(Linenum);
      } /* end if */
    } /* end Search */

  void Print_In_Order( Root)
    NodePin Root;
    { /* Print_In_Order */ /* inorder traversal */
      ItemPin Temp;
      unsigned Count = 0;
      if( Root != NULL) {
	Print_In_Order( Root->Left); /* print left subtree */
	printf( " %-15s ", Root->Name); /*15 is MAGIC number=MaxLength*/
	Temp = Root->First;
	/* Count == 0 */
	while (Temp) {
	  Count++;
	  printf("%6d", Temp->Linenum);
	  Temp = Temp->Next;
	  if( Count % MaxOnLine == 0 && Count > 0 && Temp)
	    printf( "\n                ");
	    /* end if*/
        } /* end while */
	printf("\n");
	Print_In_Order( Root->Right); /* print right subtree */
      } /* end if */
    } /* end Print_In_Order */

  void main()
    { /* main */ /* CrossReference */
      /* Root == Null; */
      while ( ( NextChar = GetNext() ) != EOF)
	if( is_letter( NextChar)) {
	  Name = GetIdent();
	  Search( &Root, Name); } /* Note: Pointer to Pointer */
      /* end while */
      Print_In_Order( Root);
    } /* end main */ /* CrossReference */
