typedef struct Spoint{
  int x,y;
} point;

typedef struct Sdpoint {
  double x,y;
} dpoint;

typedef struct SDCEL_segment {
  struct Spoint        v1,v2;   /* v1 start point, v2 end point */ 
  struct SDCEL_segment *p1,*p2; /* Counter clock wise around v1 & v2 */ 
  struct SDCEL_segment *q1,*q2; /* Clockwise around v1 & v2 */
} DCEL_segment;

typedef struct SKnode {
  point p;
  int e1,e2,e3;
} Knode;

typedef struct SEnode {
  int v1,v2;
  int p1,p2,q1,q2;
  int f1,f2;
} Enode;

typedef struct Skey {
  double radius;
  double angle;
  int number;
} Key;

typedef struct Ssplay_element {
  long key;
  point p;
} splay_element;

typedef struct Ssplay_node {
  splay_element element;
  struct Ssplay_node *father, *left, *right;
} splay_node;

typedef struct SCHpoints {
  int number;
  point node;
  int v;
  struct SCHpoints *next,*prev;
} CHpoints;


typedef struct SCHsplay_element {
  Key key;
  CHpoints *point;
} CHsplay_element;

typedef struct SCHsplay_node {
  CHsplay_element element;
  struct SCHsplay_node *father, *left, *right;
} CHsplay_node;
