(* main.sml
 *
 * COPYRIGHT (c) 1996 AT&T Research.
 *)

structure Main :> Main =
  struct
    fun doit_extra () =
      ( Int.toString(Nucleic.anticodon_length())
      )

    fun doit () =
      ( 
        print("The answer is: ");
        print(Int.toString(Nucleic.anticodon_length()));
        print("\n");
        ()
      )

    fun extra(n) =
       if n > 0 then
         ( doit_extra();
           extra(n-1)
         )
       else ()
      
    fun main (args) = 
      ( let 
          (* if a command line arg is given, convert it to an int, otherwise
               use 1 *)
          val n = if args = [] then 1 
                  else (Option.valOf(Int.fromString (hd args)))
        in
          (* extra interations just to get larger time *)
          extra(n-1);
          (* the real one *)
          doit()
        end
      )
end;

