structure Dict =
struct
  type 'a relation = 'a * 'a -> bool
  abstype ('b,'a) dictionary = DATA of {Table : ('b * 'a) list,
                                Leq : 'b * 'b -> bool }
    with
      exception LOOKUP
      fun create Leqfunc = DATA { Table = nil, Leq = Leqfunc }

      fun lookup (DATA { Table = entrylist, Leq = leq }) key =
        let fun search [] = raise LOOKUP
              | search((k,item)::entries) =
                  if leq(key,k)
                  then if leq(k,key) then item else raise LOOKUP
                  else search entries
         in search entrylist
        end

      fun enter (DATA { Table = entrylist, Leq = leq })
                (newentry as (key : 'b,item :'a)) : ('b,'a) dictionary =
        let val gt = fn a => fn b => not (leq(a,b))
            val eq = fn k => fn k' => (leq(k,k')) andalso (leq(k',k))
            fun update nil = [ newentry ]
              | update ((entry as (k,_))::entries) =
                  if (eq  key k) then newentry::entries
                  else if gt k key then newentry::(entry::entries)
                       else entry::(update entries)
         in DATA { Table = update entrylist, Leq = leq }
        end

      fun listofdict (DATA { Table = entrylist,Leq = leq}) =
        let fun f (nil,r) = rev r
              | f (a::b,r) = f (b,a::r)
         in f(entrylist,nil)
        end
   end
end (* structure Dict *)
