structure Main :> Main =
  struct
    val s = OS.FileSys.getDir()

    fun doit () = LexGen.lexGen (s^"/DATA/ml.lex")

    fun doit_extra () = doit()

    fun extra(n) =
       if n > 0 then
         ( doit_extra();
           extra(n-1)
         )
       else ()
      
    fun main (args) = 
      ( let 
          (* if a command line arg is given, convert it to an int, otherwise
               use 1 *)
          val n = if args = [] then 1 
                  else (Option.valOf(Int.fromString (hd args)))
        in
          (* extra interations just to get larger time *)
          extra(n-1);
          (* the real one *)
          doit()
        end
      )
end ;
