(* main.sml
 *
 * COPYRIGHT (c) 1992 AT&T Bell Laboratories
 *
 * Main structure for running raytracer as benchmark.
 *)


structure Main :> Main =

struct

    fun doit () = let
	  val strm = TextIO.openString ("\
		  \100 0 0 0 8 8 8 color sphere\n\
		  \/./TEST raytrace\n\
		  \stop\n\
		\")
	  in
	    Interface.rtInit();
	    Interp.parse strm
	  end

    fun doit_extra () = ( doit() )

    fun extra(n) =
       if n > 0 then
         ( doit_extra();
           extra(n-1)
         )
       else ()
      
    fun main (args) = 
      ( let 
          (* if a command line arg is given, convert it to an int, otherwise
               use 1 *)
          val n = if args = [] then 1 
                  else (Option.valOf(Int.fromString (hd args)))
        in
          (* extra interations just to get larger time *)
          extra(n-1);
          (* the real one *)
          doit()
        end
      )
end ;
