structure Bits = 
struct

fun wrap (f : Word.word * Word.word -> Word.word)
  = (fn (x : int, y : int) => 
       Word.toInt(f(Word.fromInt x, Word.fromInt y)))

val orb  = wrap Word.orb
val andb = wrap Word.andb
val xorb = wrap Word.xorb
val lshift = wrap Word.<<
val rshift = wrap Word.>>

end
