structure Main :> Main = struct 

open Misc

open SimStuff

fun doitx (ifile:string, ofile:string, c_ofile:string, ws:int) =
let val foo = Ntypes.init_names()
    val i = (dodelay o BreakInst.breaki o ReadAbs.read o open_in) ifile
    val (j, p) = time "Building Nodes" (fn () => ReadI.readI i)
    val x = time "writing unopt" (fn () => writeprog(ofile, j, p))
    fun cwin p = Compress.compress(ws, p)
    val cp = time "compressing program" (fn () => map cwin p)
    val xx = time "writing opt program" (fn () => writeprog(c_ofile, j, cp))
    val answer = "" (* SimStuff.cmprog(ofile, c_ofile) *)
    val code_motions = Ntypes.new_name "0"
in
    print (answer ^ "code_motions " ^ code_motions ^ " \n")
end

fun mmain(s:string list, env:string list) =
    let val idemp = ref 0
	val ws = ref 0
	val ifile = ref "/dev/null"
	val ofile = ref "/dev/null"
	val c_ofile = ref "/dev/null"
	val gotifile = ref false
	val gotofile = ref false
	fun digit d =
	if ord d >= ord "0" andalso ord d <= ord "9" then ord d - ord "0"
	    else err ("expected digit. got " ^ d)
	val parse =
	fn ("-" :: "i" :: "d" :: "e" :: "m" :: d :: nil) =>
	idemp := digit d
	 | ("-" :: "w" :: "s" :: d :: nil) =>
	       ws := digit d
	 | ("-" :: t)  =>
	       (print ("usage: comp [-ws#] [-idem#]" ^
		       "input_file temp_file compressed_file\n");
		print ("ws is the window size\nidem is the idempotency\n");
		err "exiting")
	 | s  => if !gotofile then c_ofile := implode s
		 else if !gotifile then (gotofile := true;
					 ofile := implode s)
		      else (gotifile := true;
			    ifile := implode s)
	val foo = List.app (parse o explode) (tl s)
	val foo = print ("compressing " ^ !ifile ^ " into (uncompressed)" ^
			 !ofile ^
			 " and (compressed)" ^ !c_ofile ^
			 " with idempotency " ^ makestring (!idemp) ^
			 " and window size " ^ makestring (!ws) ^ "\n")
    in
	Delay.idempotency := !idemp;
	doitx(!ifile, !ofile, !c_ofile, !ws)
    end

val s = OS.FileSys.getDir()

fun doit() = mmain(["foobar", "-ws9", 
		   s^"/DATA/ndotprod.s", 
		   s^"/DATA/tmp.s", 
		   s^"/DATA/cmp.s"], 
		  nil)


fun extra(n) =
       if n > 0 then
         ( doit();
           extra(n-1)
         )
       else ()
      
fun main (args) = 
  ( let 
    (* if a command line arg is given, convert it to an int, otherwise
       use 1 *)
    val n = if args = [] then 1 
            else (Option.valOf(Int.fromString (hd args)))
    in
      (* extra interations just to get larger time *)
      extra(n-1);
      (* the real one *)
      doit()
    end
  )
end 
