structure Misc = struct 

open Array (* List *)
infix 9 sub

fun fold f x y = List.foldr f y x
fun revfold f x y = List.foldl f y x
val makestring = Int.toString

local 
val == = (op =)
val != = (op <>)

open Real
in
val realEq = ==
val realNe = !=
end

exception NotAChar
fun fromStr x = 
  (case Char.fromString x
    of SOME c => c
     | NONE => raise NotAChar)

fun ordof(s, i) = Char.ord(String.sub(s, i))


val explode = (fn x => map Char.toString (explode x))
val implode = (fn x => implode (map fromStr x))
fun ord s = Char.ord (fromStr s)

val output = TextIO.output
val std_out = TextIO.stdOut
val open_in = TextIO.openIn
val open_out = TextIO.openOut
val close_in = TextIO.closeIn
val close_out = TextIO.closeOut
val input_line = TextIO.inputLine
type instream = TextIO.instream
type outstream = TextIO.outstream
fun outputc f x = TextIO.output(f, x)

exception NotAReal

fun strToReal s = 
  (case Real.fromString s
    of SOME r => r
     | _ => raise NotAReal)

fun intToReal x = 
  (strToReal ((Int.toString x) ^ ".0"))

end  (* misc *)
