structure SimStuff =
struct

open Misc
open Array
infix 9 sub

fun read file =
    let val if1 = (open_in "simprelude.s")
	val if2 = (open_in file)
	val if3 = (open_in "simpostlude.s")
	val prelude = ReadAbs.read if1
	val prog = ReadAbs.read if2
	val postlude = ReadAbs.read if3
    in
	close_in if1;
	close_in if2;
	close_in if3;
	prelude @ prog @ postlude
    end

fun init file = SetEnv.init (read file)

val runcount = ref 0

fun run ()=
    let open AbsMach
	val foo = runcount := 0
	fun updc NOP = runcount := !runcount + 1
	  | updc _ = ()
	open SetEnv
	fun f () = (step(); (updc o hd o pc)(); f())
    in
	f()
    end

fun srun () = let open SetEnv in d_pc(); step(); srun() end;

fun memsave () = !SetEnv.Memory


fun memcmp(a:AbsMach.values array, b:AbsMach.values array) = 
    let open AbsMach
	fun cmp (INT a, INT b) = a = b
	  | cmp (REAL a, REAL b) = realEq(a, b)
	  | cmp (LABVAL _, LABVAL _) = true
	  | cmp _ = false
	fun f 0 = ~1
	  | f n = if cmp((a sub n), (b sub n)) then f (n - 1) else n
	val al = Array.length a
	val bl = Array.length b
    in
	if al = bl then f (al - 1) else (print "size\n"; 0)
    end


fun copyarray a =
    let val la = Array.length a
	val na = array(la, a sub 0)
	fun f n = if n > 0 then (update(na, n, a sub n) ; f (n - 1)) else ()
	val foo = f (la - 1)
    in
	na
    end


exception PROG_NO_END

local open AbsMach
in
    fun vstring (INT i) = "INT " ^ makestring i
      | vstring (REAL i) = "REAL " ^ Real.toString i
      | vstring (LABVAL(i, j)) =
	"LABVAL(" ^ makestring i ^ ", " ^ makestring j ^ ")"
end

fun runf f = 
    ((init f;
      run ();
      raise PROG_NO_END))
    handle End_of_Program => (print "eop\n";
			      SetEnv.regc 4)
			       
    
fun cmprog(f1, f2) =
    let open AbsMach
	fun intof (INT i) = i
	fun ptsat p = SetEnv.mcell (intof p)
	val p1 = runf f1
	(* val foo = print ("cmprog1:" ^ vstring p1 ^ "\n") *)
	val v1 = ptsat p1 
	val r1 = !runcount
	val p2 = runf f2
	(* val foo = print ("cmprog2:" ^ vstring p2 ^ "\n") *)
	val v2 = ptsat p2
	val r2 = !runcount

    in
	(f1 ^ " ct " ^ makestring r1 ^ " ptr " ^ vstring p1 ^
	  " val " ^ vstring v1 ^ 
	 f2 ^ " ct " ^ makestring r2 ^ " ptr " ^ vstring p2 ^
	 " val " ^ vstring v2 ^  "\n")
    end

fun time str f =
    let (* open System.Timer
	val s = start_timer() *)
	val v = f()
        (*
	val e = check_timer s
	val foo = print (str ^ " took " ^ makestring e ^ "sec.usec\n")
        *)
    in
	v
    end


fun writeprog(file, j, p) =
    let val ot = (TextIO.openOut file)
	val prog = ReadI.writeI(j, p)
	val filp = (Delay.rm_bogus o OutFilter.remnops) prog
	val xxx = PrintAbs.show ot filp
    in
	TextIO.closeOut ot
    end;
   
fun wp(file, prog) =
    let val ot = (TextIO.openOut file)
	val filp = Delay.rm_bogus prog
	val xxx = PrintAbs.show ot filp
    in
	TextIO.closeOut ot
    end;
     
fun dodelay i = (Delay.init i; Delay.add_delay i);
    
val _ = (
Node.move_test_debug := false;
Node.move_op_debug := false;
Node.rw_debug := false;
Node.delete_debug := false;
Node.ntn_debug := true;
Node.prog_node_debug := false;
Node.prog_node_debug_verbose := false;
Node.closure_progs_debug := false;
Node.cpsiCheck := false;
Compress.compress_debug := false;
ReadI.read_debug := false;
ReadI.write_debug := false;
ReadI.live_debug := false
)
    
fun pm pl = print (StrPak.stringListString (map ReadI.progMap pl));
fun pp pl = print (StrPak.stringListString (map PrintAbs.str pl));
    
fun ndnm nil = raise Node.NAMETONODE
| ndnm(h::t) = (fn (nm) => Node.nameToNode(h, nm)
		handle Node.NAMETONODE => ndnm t nm);

exception ERROR;

fun err (s:string) = (print s; raise ERROR);

fun pmem nil = (err "oh well")
  | pmem ((ns, n0, f)::t) =
    fn n => if Set.member(ns, n) then (ns, n0, f)
	    else pmem t n;

end
