structure sortP =

struct
	    
open Misc
open Ntypes
type obj = Node.program

fun int l =
    let val z = ord "0"
	fun f(n, nil) = n
	  | f (n, d::l) =
	    if d>="0" andalso d<="9" then f(n*10+ord(d)-z, l)
	    else n
    in
	f(0,l)
    end

fun gt((nsa, n0a, Fa), (nsb, n0b, Fb)) =
    let val a = explode (Node.name_of n0a)
	val b = explode (Node.name_of n0b)
    in
	(int a) > (int b)
    end
	
fun sort l =
    let fun m2 (nil, b) = b
	  | m2 (a, nil) = a
	  | m2 (ha::ta, hb::tb) =
	    if gt(ha, hb) then hb::(m2(ha::ta, tb))
	    else ha::(m2(ta, hb::tb))
	fun ml (nil) = nil
	  | ml (h::nil) = h
	  | ml (h1::h2::nil) = m2(h1, h2)
	  | ml (h1::h2::l) = ml [m2(h1, h2), (ml l)]
    in
	ml (map (fn x => [x]) l)
    end

end
