/* seq.c
 * Pseudo instruction sequences.
 *
 * Copyright (c) 1996 T. J. Wilkinson & Associates, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@tjwassoc.demon.co.uk>
 */

#include "config.h"
#include "config-std.h"
#include "config-mem.h"
#include "gtypes.h"
#include "seq.h"

sequence* firstSeq;
sequence* lastSeq;
sequence* currSeq;

#ifdef LJH_JITDUMP
uint32 currPC;  /* pc of bytecode for which code is currently being dumped */
#endif


/*
 * Reset the sequence list.
 */
void
initSeq(void)
{
	currSeq = firstSeq;
}

/*
 * Allocate a new sequence element.
 */
sequence*
nextSeq(void)
{
	int i;
	sequence* ret = currSeq;

	if (ret == 0) {
		/* Allocate chunk of sequence elements */
		ret = checked_calloc(ALLOCSEQNR, sizeof(sequence));

		/* Attach to current chain */
		if (lastSeq == 0) {
			firstSeq = ret;
		}
		else {
			lastSeq->next = ret;
		}
		lastSeq = &ret[ALLOCSEQNR-1];

		/* Link elements into list */
		for (i = 0; i < ALLOCSEQNR-1; i++) {
			ret[i].next = &ret[i+1];
		}
		ret[ALLOCSEQNR-1].next = 0;
	}
	currSeq = ret->next;
	ret->ref = 1;
#ifdef LJH_JITDUMP
        ret->pc = currPC;  /* store the pc of bytecode */
        ret->stype = BYTECODE; /* and the fact that we are making a bytecode */
#endif
	return (ret);
}

#ifdef LJH_JITDUMP
void label_print(sequence *s)
{ if (s->stype == BYTECODE)
    printf("%7u ",s->pc);
  else if (s->stype == SPILL)
    printf("  SPILL ");
  else if (s->stype == RELOAD)
    printf(" RELOAD ");
  else
    printf("UNKNOWN ");
}
#endif
