/*
 * soft.h
 * Soft instruction prototypes.
 *
 * Copyright (c) 1996 T. J. Wilkinson & Associates, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@tjwassoc.demon.co.uk>, 1996.
 */

#ifndef __soft_h
#define	__soft_h

struct _dispatchTable;
struct _classes;
struct _object;
struct _gcHead;

void*	soft_new(Class*);
void*	soft_anewarray(Class*, jint);
void*	soft_newarray(jint, jint);
void	soft_initialise_class (Class* c);
nativecode* soft_get_method_code (Method*);

void	soft_monitorenter(struct _object*);
void	soft_monitorexit(struct _object*);

void*	soft_lookupmethod(Object*, struct _methods*);
void	soft_checkcast(struct _classes*, struct _object*);
jint	soft_instanceof(struct _classes*, struct _object*);

void	soft_athrow(struct _object*);
void	soft_badarrayindex(void);
void	soft_nullpointer(void);

void	soft_addtogc(struct _gcHead*);

jint	soft_dcmpg(jdouble, jdouble);
jint	soft_dcmpl(jdouble, jdouble);
jint	soft_fcmpg(jfloat, jfloat);
jint	soft_fcmpl(jfloat, jfloat);

jint	soft_mul(jint, jint);
jint	soft_div(jint, jint);
jint	soft_rem(jint, jint);

#if defined(INTERPRETER)
void*	soft_multianewarray(struct _classes*, jint, slots*);
#endif

#if defined(TRANSLATOR)
jlong	soft_lmul(jlong, jlong);
jlong	soft_ldiv(jlong, jlong);
jlong	soft_lrem(jlong, jlong);
jfloat	soft_frem(jfloat, jfloat);
jdouble	soft_freml(jdouble, jdouble);
jlong	soft_lshll(jlong, jint);
jlong	soft_ashrl(jlong, jint);
jlong	soft_lshrl(jlong, jint);
jint	soft_lcmp(jlong, jlong);
void*	soft_multianewarray(struct _classes*, jint, ...);
#endif

jlong	soft_cvtil(jint);
jint	soft_cvtli(jlong);
jfloat	soft_cvtlf(jlong);
jdouble	soft_cvtld(jlong);
jlong	soft_cvtfl(jfloat);
jlong	soft_cvtdl(jdouble);

jint instanceof(Class*, Class*);
jint instanceof_array(Class*, Class*);


#ifdef LJH_JITDUMP
char * soft_fn_fname(uintp);  /* given a fn ptr, give back its name */
#endif

#endif

